from bpy.types import Panel
# from ...addon.naming import FluidLabNaming
from ..ui_module_panel import FLUIDLAB_ModulePanel
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.common_ui_elements import title_header


class FLUIDLAB_PT_fluid_interactions_ui(Panel, FLUIDLAB_ModulePanel):
    fluidlab_section = 'FLUID_INTERACTIONS'
    bl_idname = "FLUIDLAB_PT_fluid_interactions_ui"
    bl_label = "Module"

    def draw(self, context):

        fluid_interactions, ui = get_common_vars(context, get_fluid_interactions=True, get_ui=True)

        layout = self.layout

        layout.use_property_split = True
        layout.use_property_decorate = False

        col = layout.column(align=True)
        title_header(col, "Fluid Interactions")

        main_col = col.box().column(align=True)
        main_col.use_property_split = True
        main_col.use_property_decorate = False
        
        # -------------------------------------------------------------------------------
        # ## UI BASICA ##
        # ------------------------------------------------------------------------------- 
        if ui.ui_mode == 'BASIC':
            main_col.label(text="Hola Mundo Basico")

    
        # -------------------------------------------------------------------------------
        # ## UI AVANZADA ##
        # ------------------------------------------------------------------------------- 
        elif ui.ui_mode == 'ADVANCED':

            main_col.template_list("FLUIDLAB_UL_draw_fluids_interactions", "", fluid_interactions, "list", fluid_interactions, "list_index", rows=3)
            add_bt = main_col.row(align=True)
            add_bt.scale_y = 1.28 # parece que blender tiene un bug en esta situación (1.3 no dibuja el panel...) :S
            add_bt.operator("fluidlab.fluid_interactions_list_add", text="Add Interaction")
